﻿//////////////////////////////////////////////
// AttributeGenerationInfo.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Enums/IndexFormat.h"

#include "../InputLayouts/MeshInputLayoutAttribute.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	struct AttributeGenerationInfo final
	{
		// Input data information
		nkMemory::BufferView<unsigned char> _positionBuffer ;
		nkMemory::BufferView<unsigned char> _texCoordBuffer ;
		nkMemory::BufferView<unsigned char> _indexBuffer ;

		MeshInputLayoutAttribute _positionAttribute ;
		MeshInputLayoutAttribute _texCoordAttribute ;
		INDEX_FORMAT _indexFormat = INDEX_FORMAT::UINT32 ;

		unsigned int _positionBufferStride = 0u ;
		unsigned int _texCoordBufferStride = 0u ;

		bool _frontCcw = true ;
	} ;
}